from fleming.system_test.fle_sys import *


# Aperture Handling Functions
#=====================================================================================    
# High Level Functions to import in GroundControl: predefined Tasks
# 2022-03-18/Kay Struebing
# 

# Global Constants
PATH, SCRIPT = os.path.split(__file__)
BASE_NAME = SCRIPT.split('.')[0]
ADJUSTMENT_PATH = '/home/pkiuser/.config/pyrunner/'

async def aperture_change_test(cycles = 1):
    aperture_type = 1
    for c in range(cycles):
        try:
            await Measurements.instance.instrument.PutAperture(aperture_type)
            await Measurements.instance.instrument.RemoveAperture(aperture_type)
        except Exception as ex:
            return('Aperture change failed.')
    return('Aperture change test done.')

async def aperture_present_test(cycles = 1):
    # Ground Control automated tests
    # Aperture Present Sensor Test 
    # GC_Params must be set:
    # - AperturePresentCheckNull: Check Position: APS = 0
    # - NoAperturePresentCheck: Check Position: APS = 1
    # - ApertureDetection: Aperture Detection Position
    # aps_value = 0: Aperture present
    # aps_value = 1: No Aperture present

    TEST_NAME = 'aperture_present_test'
    sensor_fbd = 6
    sensor_us = 7

    #REF7 = 6
    result = 0
    check_pos_present = fm_enum.Positions.ApertureSensorLow_mm # 7.5
    check_pos_not_present = fm_enum.Positions.ApertureSensorHigh_mm # 2.5
    aperture_detection_pos = fm_enum.Positions.ApertureSensorMeasuring_mm # -0.2

    try:
        board = VUnits.instance.hal.nodes['MC6']
        if head == "fbd":
            fm = VUnits.instance.hal.focusMover
            sensor = sensor_fbd
        else if head == "us":
            fm = VUnits.instance.hal.usLumfocusMover 
            sensor = sensor_us
        else:
            head = "fbd"
    except Exception as ex:
        PyLogger.logger.error(ex)


    try:
        await fm.Home()
        await send_msg(json.dumps({"result": f"{TEST_NAME} started."}))
        for c in range(cycles):
            # Check Sensor = 0
            await fm.GotoPosition(check_pos_present)
            if (await board.GetDigitalInput(sensor))[0] == 0:
                msg = f"{TEST_NAME}: Check Sensor 0: OK"
                await send_msg(json.dumps({"result": msg}))
                result = 1
            else:
                msg = f"{TEST_NAME}: Check Sensor 0: failed"
                await send_msg(json.dumps({"result": msg}))
                result = 0
            
            # Check Sensor = 1
            await fm.GotoPosition(check_pos_not_present)
            if (await board.GetDigitalInput(sensor))[0] == 1:
                msg = f"{TEST_NAME}: Check Sensor 0: OK"
                await send_msg(json.dumps({"result": msg}))
                result = 1
            else:
                msg = f"{TEST_NAME}: Check Sensor 1: failed"
                await send_msg(json.dumps({"result": msg}))
                result = 0

            # Check Aperture Detection
            await fm.GotoPosition(aperture_detection_pos)
            if (await board.GetDigitalInput(sensor))[0] == 1 and result:
                msg = f"{TEST_NAME}: OK, no Aperture present."
                await send_msg(json.dumps({"result": msg}))
            else:
                msg = f"{TEST_NAME}: failed."
                await send_msg(json.dumps({"result": msg}))


    except Exception as ex:
        PyLogger.logger.error(ex)
        return ex
    
    return msg


async def aperture_present_scan(head = "fbd", start_pos = -0.5, stop_pos = 10, steps_per_mm = 10):

    sensor_fbd = 6
    sensor_us = 7
    aps_value = 0
    # Detection Position FocusMover 
    # Test Sensor Position = 0
    # aps_value = 0: Aperture present
    # aps_value = 1: No Aperture present
    
    start_fm = start_pos
    stop_fm = stop_pos
    
    try:
        board = VUnits.instance.hal.nodes['MC6']
        if head == "us":
            fm = VUnits.instance.hal.usLumFocusMover
            sensor = sensor_us
        else:
            fm = VUnits.instance.hal.focusMover 
            sensor = sensor_fbd
    except Exception as ex:
        PyLogger.logger.error(ex)

    try:
        await fm.Home()
        await send_msg(json.dumps({"result": f"Aperture Present Scan Head: {head}"}))
        await send_msg(json.dumps({"result": f"pos;aps_value"}))
        
        for pos in range(int((stop_fm - start_fm) * steps_per_mm)):
            await fm.Move(start_fm + pos/steps_per_mm)
            aps_value = (await board.GetDigitalInput(sensor))[0]
            await send_msg(json.dumps({"result": f"{pos/steps_per_mm + start_fm:4.2f};{aps_value}"}))

    except Exception as ex:
        PyLogger.logger.error(ex)
    
    return 

